﻿using System.Net;
using System.Threading.Tasks;
using System.Windows;
using System.Threading;

namespace SchedulerContext
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        // Listing 16-23. Nieefektywny sposób anulowania
        private CancellationTokenSource cancelSource;

        void OnButtonClick(object sender, RoutedEventArgs e)
        {
            cancelSource = new CancellationTokenSource();
            TaskScheduler uiScheduler =
            TaskScheduler.FromCurrentSynchronizationContext();
            Task<string>.Factory.StartNew(GetData, cancelSource.Token)
            .ContinueWith((task) => UpdateUi(task.Result),
            uiScheduler);
        }

        void OnCancelClick(object sender, RoutedEventArgs e)
        {
            if (cancelSource != null)
            {
                cancelSource.Cancel();
            }
        }
        string GetData()
        {
            WebClient w = new WebClient();
            return w.DownloadString("http://helion.pl/");
        }
        void UpdateUi(string info)
        {
            cancelSource = null;
            myTextBox.Text = info;
        }
    }
}
